/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8275;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicHelp;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.JdmLayout;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.common.AccessDenied;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.NotSupported;
import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.common.Timeout;
import ibm.nways.jdm.eui.BoxDownMsg;
import ibm.nways.jdm.eui.WrongSysOidMsg;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.ras.RAS;
import ibm.nways.widgets.CookieTray;
import ibm.nways.widgets.WidgetCookie;
import java.awt.Component;
import java.awt.Label;
import java.awt.Point;
import java.io.Serializable;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class BoxInfo {
    private static ResourceBundle myBundle;
    private static String bundleName;
    public static final int RASID = 19;
    public static final int RASSUB = 7;
    public static final String PROPNAME = "BoxInfo.jdm8275.nways.ibm";
    protected static final String PropertiesFile = "properties/Jdm8275.txt";
    public static final String serPath = "ibm.nways.jdm8275.WCDefault";
    public static final int TIMEOUT_REPEAT = 5;
    public static final int NoStatus = 0;
    public static final int AllisWell = 1;
    public static final int NotResponding = 2;
    public static final int WrongBox = 3;
    public static final int ServerProblems = 4;
    public static final int Model_113 = 1;
    public static final int Model_217 = 2;
    public static final int Model_225 = 3;
    public static final OID Model_113SysOID;
    public static final OID Model_217SysOID;
    public static final OID Model_225SysOID;
    public static final int Version1_0 = 1;
    public static final int Version1_1 = 2;
    private static final int SUCCESSFUL = 0;
    private static final int FAILED = 1;
    private OIDInfo oidInfo;
    private UFCInfo ufcInfo;
    private CookieTray[] ufcArray;
    private GenModel deviceModel;
    private GenModel portModel;
    private GenModel systemModel;
    private JdmBrowser deviceBrowser;
    private int deviceStatus;
    private int retrievalStatus;
    private GraphicPanel deviceGraphic;
    private OID deviceSysOID;
    private int agentVersion;
    private int currentNumOfPorts = 27;
    private int deviceType;
    private boolean isApplication;
    boolean loggingOn = false;

    public BoxInfo(GenModel genModel, JdmBrowser jdmBrowser) {
        String string = "BoxInfo";
        if (RAS.isEnabled(19, 7)) {
            RAS.enter(19, 7, this, string);
        }
        ModelInfo modelInfo = null;
        Serializable serializable = null;
        this.oidInfo = new OIDInfo();
        this.ufcInfo = new UFCInfo();
        this.deviceBrowser = jdmBrowser;
        this.deviceModel = genModel;
        myBundle = ResourceBundle.getBundle(bundleName);
        try {
            modelInfo = this.deviceModel.getInfo("Initial");
            serializable = modelInfo.get("Initial.SysObjectID");
            if (serializable instanceof Timeout || serializable instanceof NotSupported || serializable instanceof AccessDenied) {
                this.deviceStatus = 2;
                if (RAS.isEnabled(19, 7)) {
                    RAS.trace(19, 7, this, string, "Device not responding, got " + serializable.toString());
                }
                new BoxDownMsg(jdmBrowser.getFrame(), myBundle.getString("deviceName"));
            } else {
                this.deviceSysOID = new OID(serializable.toString());
                if (!this.oidInfo.containsKey(this.deviceSysOID)) {
                    if (RAS.isEnabled(19, 7)) {
                        RAS.trace(19, 7, this, string, "Wrong device. SysOID = " + this.deviceSysOID);
                    }
                    this.deviceStatus = 3;
                    new WrongSysOidMsg(this.deviceBrowser.getFrame(), myBundle.getString("deviceName"));
                } else {
                    this.deviceStatus = 1;
                    if (this.deviceSysOID.equals(Model_113SysOID)) {
                        this.deviceType = 1;
                    } else if (this.deviceSysOID.equals(Model_217SysOID)) {
                        this.deviceType = 2;
                    } else if (this.deviceSysOID.equals(Model_225SysOID)) {
                        this.deviceType = 3;
                    }
                    this.retrievalStatus = this.getNecessaryModels();
                }
            }
        }
        catch (Exception exception) {
            this.deviceStatus = 4;
            if (RAS.isEnabled(19, 7)) {
                RAS.trace(19, 7, this, string, "Error getting inital sysoid data");
            }
            RAS.logException(19, 7, this, string, exception);
        }
        if (this.deviceStatus == 1) {
            serializable = modelInfo.get("Initial.Version11Item");
            this.agentVersion = serializable instanceof Integer ? 2 : 1;
        }
        if (RAS.isEnabled(19, 7)) {
            RAS.exit(19, 7, this, string);
        }
    }

    private int getNecessaryModels() {
        String string = "getNecessaryModels";
        if (RAS.isEnabled(19, 7)) {
            RAS.enter(19, 7, this, string);
        }
        int n = 0;
        String string2 = null;
        if (RAS.isEnabled(19, 7)) {
            RAS.tracedetail(19, 7, this, string, "Attempting to retrieve the following componenets : ");
        }
        try {
            if (this.deviceType <= 1) {
                string2 = "PortCfg";
                if (RAS.isEnabled(19, 7)) {
                    RAS.tracedetail(19, 7, this, string, string2);
                }
                if (this.deviceType == 0 && RAS.isEnabled(19, 7)) {
                    RAS.trace(19, 7, this, string, "Can not recognize device type");
                }
                this.portModel = (GenModel)this.deviceModel.getComponent(string2);
            } else if (this.deviceType > 1) {
                string2 = "PortCfg2";
                if (RAS.isEnabled(19, 7)) {
                    RAS.tracedetail(19, 7, this, string, string2);
                }
                this.portModel = (GenModel)this.deviceModel.getComponent(string2);
            }
            string2 = "System";
            if (RAS.isEnabled(19, 7)) {
                RAS.tracedetail(19, 7, this, string, string2);
            }
            this.systemModel = (GenModel)this.deviceModel.getComponent(string2);
        }
        catch (Exception exception) {
            n = 1;
            if (RAS.isEnabled(19, 7)) {
                RAS.trace(19, 7, this, string, "Trouble getting component" + string2);
            }
            RAS.logException(19, 7, this, string, exception);
        }
        if (RAS.isEnabled(19, 7)) {
            RAS.exit(19, 7, this, string);
        }
        return n;
    }

    public static void setInNavContext(NavigationContext navigationContext, BoxInfo boxInfo) {
        navigationContext.put((Object)PROPNAME, (Object)boxInfo);
    }

    public static BoxInfo getFromNavContext(NavigationContext navigationContext, boolean bl) {
        return (BoxInfo)navigationContext.get((Object)PROPNAME, bl);
    }

    public JdmBrowser getDeviceBrowser() {
        return this.deviceBrowser;
    }

    public GenModel getDeviceModel() {
        return this.deviceModel;
    }

    public int getDeviceStatus() {
        return this.deviceStatus;
    }

    public int getAgentVersion() {
        return this.agentVersion;
    }

    public int getDeviceType() {
        return this.deviceType;
    }

    public int getCurrentNumOfPorts() {
        return this.currentNumOfPorts;
    }

    public GraphicPanel getDeviceGraphic() {
        String string = "getDeviceGraphic";
        if (RAS.isEnabled(19, 7)) {
            RAS.enter(19, 7, this, string);
        }
        if (this.deviceStatus == 1 && this.retrievalStatus == 0) {
            Object object;
            Properties properties;
            Serializable serializable;
            if (this.deviceGraphic != null) {
                return this.deviceGraphic;
            }
            try {
                serializable = new URL(this.deviceBrowser.getDocumentBase(), PropertiesFile);
                properties = new Properties();
                properties.load(((URL)serializable).openStream());
            }
            catch (Exception exception) {
                if (RAS.isEnabled(19, 7)) {
                    RAS.trace(19, 7, this, string, "Error getting properties: ");
                }
                properties = null;
                RAS.logException(19, 7, this, string, exception);
            }
            JdmLayout jdmLayout = (JdmLayout)this.deviceBrowser.getLayout();
            if (properties != null) {
                serializable = new Integer((String)((Hashtable)properties).get("layout.scheme"));
                if (RAS.isEnabled(19, 7)) {
                    RAS.trace(19, 7, this, string, "The layout scheme prpt = " + serializable);
                }
                int n = (Integer)serializable;
                jdmLayout.setScheme(n);
                object = (String)((Hashtable)properties).get("layout.fractions");
                StringTokenizer stringTokenizer = new StringTokenizer((String)object);
                float[] fArray = new float[stringTokenizer.countTokens()];
                boolean bl = true;
                int n2 = 0;
                while (n2 < fArray.length && stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    try {
                        fArray[n2] = Float.valueOf(string2).floatValue();
                    }
                    catch (NumberFormatException numberFormatException) {
                        RAS.logError(19, 7, this, string, "EXCEPTION_CALCULATING_FRACTIONS");
                        RAS.logException(19, 7, this, string, (Exception)numberFormatException);
                        bl = false;
                    }
                    ++n2;
                }
                if (bl) {
                    jdmLayout.setFracts(fArray);
                }
            } else {
                int n = 0;
                jdmLayout.setScheme(n);
            }
            GraphicContainer graphicContainer = new GraphicContainer();
            serializable = new GraphicHelp((BrowserApplet)this.deviceBrowser, new Point(0, 0), new HelpRef((Object)this));
            graphicContainer.add((GraphicComponent)serializable);
            object = new Label(myBundle.getString("front_view"), 1);
            ((Component)object).setLocation(new Point(35, 0));
            graphicContainer.add((Component)object);
            graphicContainer.add((GraphicContainer)this.createFrontView());
            object = new Label(myBundle.getString("back_view"), 1);
            ((Component)object).setLocation(new Point(35, 125));
            graphicContainer.add((Component)object);
            graphicContainer.add((GraphicContainer)this.createBackView());
            this.deviceGraphic = new GraphicPanel((GraphicHandler)this.deviceBrowser, (Component)graphicContainer);
        } else if (RAS.isEnabled(19, 7)) {
            RAS.trace(19, 7, this, string, "No information to construct the device graphic is available.");
        }
        if (RAS.isEnabled(19, 7)) {
            RAS.exit(19, 7, this, string);
        }
        return this.deviceGraphic;
    }

    public void dispose() {
        String string = "dispose";
        if (RAS.isEnabled(19, 7)) {
            RAS.enter(19, 7, this, string);
        }
        if (this.deviceGraphic != null) {
            this.deviceGraphic.dispose();
            this.deviceGraphic = null;
        }
        if (this.deviceGraphic != null) {
            this.deviceGraphic.dispose();
            this.deviceGraphic = null;
        }
        if (RAS.isEnabled(19, 7)) {
            RAS.exit(19, 7, this, string);
        }
    }

    private CookieTray createFrontView() {
        WidgetCookie widgetCookie;
        String string;
        String string2 = this.deviceType == 1 ? "ibm.nways.jdm8275.eui.PortCfgPanel" : "ibm.nways.jdm8275.eui.PortCfg2Panel";
        CookieTray cookieTray = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        Point point = new Point(-1, -1);
        CookieTray cookieTray2 = null;
        int n = 0;
        new Integer(-99);
        this.ufcArray = new CookieTray[this.oidInfo.getNumSlots(this.deviceSysOID)];
        String string6 = "createFrontView";
        if (RAS.isEnabled(19, 7)) {
            RAS.enter(19, 7, this, string6);
        }
        try {
            string3 = new String("/ibm/nways/jdm8275/" + this.oidInfo.getFrontImage(this.deviceSysOID));
            string4 = new String(this.oidInfo.getModel(this.deviceSysOID));
            string5 = new String(string4.substring(5));
        }
        catch (Exception exception) {
            if (RAS.isEnabled(19, 7)) {
                RAS.trace(19, 7, this, string6, "There was an exception in retrieving data from the OID table");
            }
            RAS.logException(19, 7, this, string6, exception);
        }
        if (RAS.isEnabled(19, 7)) {
            RAS.trace(19, 7, this, string6, "Creating " + string4 + "'s backplane, with image named " + string3);
        }
        try {
            cookieTray2 = new CookieTray(bundleName, this.oidInfo.getFrontPosition(this.deviceSysOID), string3, string4, this.deviceBrowser, this.systemModel, "ibm.nways.mib2.eui.SystemPanel");
        }
        catch (Exception exception) {
            if (RAS.isEnabled(19, 7)) {
                RAS.trace(19, 7, this, string6, "Error attempting to create " + string4);
            }
            RAS.logException(19, 7, this, string6, exception);
        }
        int n2 = 0;
        while (n2 < this.oidInfo.getNumOfExtrasFront(this.deviceSysOID)) {
            string = new String(String.valueOf(string5) + this.oidInfo.getExtras(this.deviceSysOID, n2));
            if (RAS.isEnabled(19, 7)) {
                RAS.trace(19, 7, this, string6, "Creating extra port " + string);
            }
            try {
                widgetCookie = new WidgetCookie(string, bundleName, null, serPath, null, this.deviceBrowser, 22);
                cookieTray2.AddWidget(widgetCookie);
            }
            catch (NullPointerException nullPointerException) {
                if (RAS.isEnabled(19, 7)) {
                    RAS.trace(19, 7, this, string6, "Error attempting to create widget cookie " + string);
                }
                RAS.logException(19, 7, this, string6, (Exception)nullPointerException);
            }
            ++n2;
        }
        ModelInfo modelInfo = null;
        boolean bl = true;
        Integer n3 = null;
        int n4 = 0;
        while (n4 < 5 && bl) {
            block48: {
                Vector vector;
                if (RAS.isEnabled(19, 7)) {
                    RAS.trace(19, 7, this, string6, "Retrieving the port information. Attempt " + n4);
                }
                try {
                    vector = this.portModel.getRestOfInfo("Graphics", "default", modelInfo, null);
                    int n5 = 1;
                    while (n5 <= vector.size()) {
                        block50: {
                            int n6;
                            int n7;
                            ModelInfo modelInfo2;
                            block52: {
                                Integer n8;
                                block51: {
                                    ModelInfo modelInfo3;
                                    block49: {
                                        modelInfo3 = (ModelInfo)vector.elementAt(n5 - 1);
                                        bl = false;
                                        if (modelInfo3.timeoutDetected) {
                                            bl = true;
                                            if (RAS.isEnabled(19, 7)) {
                                                RAS.trace(19, 7, this, string6, "TimeOUTS !! while adding ports ...");
                                            }
                                            if (n5 > 1) {
                                                --n4;
                                            }
                                            break;
                                        }
                                        modelInfo = modelInfo3;
                                        Serializable serializable = modelInfo3.get("Index.Port");
                                        if (serializable instanceof Integer) {
                                            n3 = (Integer)serializable;
                                        }
                                        modelInfo2 = null;
                                        modelInfo2 = new ModelInfo();
                                        modelInfo2.add("Index.Port", n3);
                                        if (n3 > this.oidInfo.getNumPorts(this.deviceSysOID)) break block49;
                                        string = new String(String.valueOf(string5) + "Port" + n3);
                                        if (RAS.isEnabled(19, 7)) {
                                            RAS.trace(19, 7, this, string6, "Regular Port " + string);
                                        }
                                        try {
                                            widgetCookie = new WidgetCookie(string, bundleName, modelInfo2, serPath, this.portModel, this.deviceBrowser, 16, string2);
                                            cookieTray2.AddWidget(widgetCookie);
                                        }
                                        catch (Exception exception) {
                                            if (RAS.isEnabled(19, 7)) {
                                                RAS.trace(19, 7, this, string6, "There was an error in creating " + string);
                                            }
                                            RAS.logException(19, 7, this, string6, exception);
                                        }
                                        break block50;
                                    }
                                    n8 = (Integer)modelInfo3.get("Graphics.SwPortCfgPortIfType");
                                    if (RAS.isEnabled(19, 7)) {
                                        RAS.trace(19, 7, this, string6, "Modular port type is " + n8);
                                    }
                                    n7 = 0;
                                    n6 = n3 - this.oidInfo.getNumPorts(this.deviceSysOID);
                                    if (this.deviceType != 1) break block51;
                                    if (n8 == 2) break block50;
                                    n7 = n8;
                                    break block52;
                                }
                                if (n8 != 1) {
                                    n7 = n8 + 1;
                                    n7 = n6 == 1 ? (n7 *= 10) : (n7 *= 100);
                                }
                                break block50;
                            }
                            String string7 = this.ufcInfo.getName(new Integer(n7));
                            if (RAS.isEnabled(19, 7)) {
                                RAS.trace(19, 7, this, string6, " Slot " + n6 + " has " + n7);
                            }
                            if (!string7.equals("BAD")) {
                                String string8 = this.ufcInfo.getImage(new Integer(n7));
                                String string9 = new String("/ibm/nways/jdm8275/" + string8);
                                Point point2 = new Point(this.oidInfo.getSlotCoords(this.deviceSysOID, n6));
                                if (point2.equals(point)) {
                                    if (RAS.isEnabled(19, 7)) {
                                        RAS.trace(19, 7, this, string6, "Error ! Could not recognize slot " + n6);
                                    }
                                } else {
                                    string = new String(String.valueOf(string7) + "_Port1");
                                    try {
                                        cookieTray = new CookieTray(bundleName, point2, string9, string7, this.deviceBrowser, this.portModel, string2);
                                        widgetCookie = new WidgetCookie(string, bundleName, modelInfo2, serPath, this.portModel, this.deviceBrowser, 16, string2);
                                        widgetCookie.SetFlyover("Port", n3.intValue());
                                        cookieTray.AddWidget(widgetCookie);
                                        if (n7 == 3 || n7 == 300) {
                                            string = new String(String.valueOf(string7) + "_PortMDI");
                                            try {
                                                widgetCookie = new WidgetCookie(string, bundleName, null, serPath, null, this.deviceBrowser, 22);
                                                cookieTray.AddWidget(widgetCookie);
                                            }
                                            catch (Exception exception) {
                                                if (RAS.isEnabled(19, 7)) {
                                                    RAS.trace(19, 7, this, string6, "There was an error in creating port " + string);
                                                }
                                                RAS.logException(19, 7, this, string6, exception);
                                            }
                                        }
                                    }
                                    catch (Exception exception) {
                                        if (RAS.isEnabled(19, 7)) {
                                            RAS.trace(19, 7, this, string6, "There was an error creating the graphic: " + string9);
                                            RAS.trace(19, 7, this, string6, "when attempted to create cookie tray " + string7 + " OR");
                                            RAS.trace(19, 7, this, string6, " There was an error in creating port " + string);
                                        }
                                        RAS.logException(19, 7, this, string6, exception);
                                    }
                                    if (cookieTray != null) {
                                        if (n7 / 10 > 1 && n7 / 10 < 10) {
                                            cookieTray2.add((GraphicContainer)cookieTray);
                                        } else {
                                            if (this.deviceType > 1) {
                                                --n6;
                                            }
                                            this.ufcArray[n6] = cookieTray;
                                        }
                                    }
                                }
                            } else if (RAS.isEnabled(19, 7)) {
                                RAS.trace(19, 7, this, string6, "ERROR -> Can't recognize this ufc");
                            }
                        }
                        ++n5;
                    }
                }
                catch (Exception exception) {
                    ++n;
                    vector = new Vector();
                    if (!RAS.isEnabled(19, 7)) break block48;
                    RAS.trace(19, 7, this, string6, " Trouble getting models");
                }
            }
            ++n4;
        }
        if (n3 != null) {
            this.currentNumOfPorts = n3;
        }
        if (RAS.isEnabled(19, 7)) {
            RAS.trace(19, 7, this, string6, "Finished retrieving the port & UFC information ");
            RAS.exit(19, 7, this, string6);
        }
        return cookieTray2;
    }

    private CookieTray createBackView() {
        String string;
        CookieTray cookieTray;
        String string2;
        String string3;
        String string4;
        block22: {
            String string5 = this.deviceType == 1 ? "ibm.nways.jdm8275.eui.PortCfgPanel" : "ibm.nways.jdm8275.eui.PortCfg2Panel";
            string4 = null;
            string3 = null;
            string2 = null;
            new Point(-1, -1);
            cookieTray = null;
            new Integer(-99);
            string = "createBackView";
            if (RAS.isEnabled(19, 7)) {
                RAS.enter(19, 7, this, string);
            }
            try {
                string4 = new String("/ibm/nways/jdm8275/" + this.oidInfo.getBackImage(this.deviceSysOID));
                string3 = new String(this.oidInfo.getModel(this.deviceSysOID));
            }
            catch (Exception exception) {
                if (RAS.isEnabled(19, 7)) {
                    RAS.trace(19, 7, this, string, "There was an exception in retrievig the data");
                }
                RAS.logException(19, 7, this, string, exception);
            }
            try {
                string2 = new String(string3.substring(5));
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                if (!RAS.isEnabled(19, 7)) break block22;
                RAS.trace(19, 7, this, string, "An exception ocurred while attempting to retrieve model type");
            }
        }
        if (RAS.isEnabled(19, 7)) {
            RAS.trace(19, 7, this, string, "Creating " + string3 + "'s backplane, with image named " + string4);
        }
        try {
            cookieTray = new CookieTray(bundleName, this.oidInfo.getBackPosition(this.deviceSysOID), string4, string3, this.deviceBrowser, this.systemModel, "ibm.nways.mib2.eui.SystemPanel");
        }
        catch (Exception exception) {
            if (RAS.isEnabled(19, 7)) {
                RAS.trace(19, 7, this, string, "Error attempting to create " + string3);
            }
            RAS.logException(19, 7, this, string, exception);
        }
        int n = 0;
        while (n < this.oidInfo.getNumOfExtrasBack(this.deviceSysOID)) {
            String string6 = new String(String.valueOf(string2) + this.oidInfo.getExtras(this.deviceSysOID, this.oidInfo.getNumOfExtrasFront(this.deviceSysOID) + n));
            if (RAS.isEnabled(19, 7)) {
                RAS.trace(19, 7, this, string, "Creating extra port " + string6);
            }
            try {
                WidgetCookie widgetCookie = new WidgetCookie(string6, bundleName, null, serPath, null, this.deviceBrowser, 22);
                cookieTray.AddWidget(widgetCookie);
            }
            catch (NullPointerException nullPointerException) {
                if (RAS.isEnabled(19, 7)) {
                    RAS.trace(19, 7, this, string, "Error attempting to create widget cookie " + string6);
                }
                RAS.logException(19, 7, this, string, (Exception)nullPointerException);
            }
            ++n;
        }
        if (RAS.isEnabled(19, 7)) {
            RAS.trace(19, 7, this, string, "Creating the UFCs on the back");
        }
        int n2 = 1;
        while (n2 < this.ufcArray.length) {
            CookieTray cookieTray2 = this.ufcArray[n2];
            if (cookieTray2 == null) {
                if (RAS.isEnabled(19, 7)) {
                    RAS.trace(19, 7, this, string, "Slot " + n2 + " is empty");
                }
            } else {
                cookieTray.add((GraphicContainer)cookieTray2);
                if (RAS.isEnabled(19, 7)) {
                    RAS.trace(19, 7, this, string, "Adding ufc on back slot " + n2);
                }
            }
            ++n2;
        }
        if (RAS.isEnabled(19, 7)) {
            RAS.exit(19, 7, this, string);
        }
        return cookieTray;
    }

    static {
        bundleName = "ibm.nways.jdm8275.GeneralResources";
        Model_113SysOID = new OID(".1.3.6.1.4.1.2.6.148");
        Model_217SysOID = new OID(".1.3.6.1.4.1.2.3.49");
        Model_225SysOID = new OID(".1.3.6.1.4.1.2.3.50");
    }

    private class OIDTable
    extends Hashtable {
        public void create(OID oID) {
            try {
                this.put(oID, new Hashtable());
                return;
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
        }

        public Hashtable getHash(OID oID) {
            return (Hashtable)this.get(oID);
        }

        OIDTable() {
            BoxInfo.this = BoxInfo.this;
        }
    }

    private class OIDInfo {
        OIDTable oidTable;

        public OIDInfo() {
            BoxInfo.this = BoxInfo.this;
            this.oidTable = new OIDTable();
            OID oID = new OID(Model_113SysOID);
            Integer n = new Integer(2);
            Integer n2 = new Integer(12);
            this.oidTable.create(oID);
            this.oidTable.getHash(oID).put("Model", "8275-113");
            this.oidTable.getHash(oID).put("Front Image", "front8275-113.gif");
            this.oidTable.getHash(oID).put("Back Image", "back8275.gif");
            this.oidTable.getHash(oID).put("Front Position", new Point(30, 25));
            this.oidTable.getHash(oID).put("Back Position", new Point(30, 150));
            this.oidTable.getHash(oID).put("Number of Slots", n);
            this.oidTable.getHash(oID).put("Number of ports", n2);
            this.oidTable.getHash(oID).put("Coords for Slot", new Vector(n));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(13, 41));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(137, 41));
            this.oidTable.getHash(oID).put("Number of extra stuff in front", new Integer(4));
            this.oidTable.getHash(oID).put("Number of extra stuff in back", new Integer(1));
            this.oidTable.getHash(oID).put("Extras", new Vector());
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("RS232");
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("Power");
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("MDIPort1");
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("MDIPort11");
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("AUI");
            oID = new OID(Model_217SysOID);
            n = new Integer(3);
            n2 = new Integer(16);
            this.oidTable.create(oID);
            this.oidTable.getHash(oID).put("Model", "8275-217");
            this.oidTable.getHash(oID).put("Front Image", "front8275-217.gif");
            this.oidTable.getHash(oID).put("Back Image", "back8275_v2.gif");
            this.oidTable.getHash(oID).put("Front Position", new Point(30, 25));
            this.oidTable.getHash(oID).put("Back Position", new Point(30, 150));
            this.oidTable.getHash(oID).put("Number of Slots", n);
            this.oidTable.getHash(oID).put("Number of ports", n2);
            this.oidTable.getHash(oID).put("Coords for Slot", new Vector(n));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(566, 41));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(25, 25));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(185, 25));
            this.oidTable.getHash(oID).put("Number of extra stuff in front", new Integer(3));
            this.oidTable.getHash(oID).put("Number of extra stuff in back", new Integer(0));
            this.oidTable.getHash(oID).put("Extras", new Vector());
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("RS232");
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("Power");
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("MDIPort1");
            oID = new OID(Model_225SysOID);
            n = new Integer(3);
            n2 = new Integer(24);
            this.oidTable.create(oID);
            this.oidTable.getHash(oID).put("Model", "8275-225");
            this.oidTable.getHash(oID).put("Front Image", "front8275-225.gif");
            this.oidTable.getHash(oID).put("Back Image", "back8275_v2.gif");
            this.oidTable.getHash(oID).put("Front Position", new Point(30, 25));
            this.oidTable.getHash(oID).put("Back Position", new Point(30, 150));
            this.oidTable.getHash(oID).put("Number of Slots", n);
            this.oidTable.getHash(oID).put("Number of ports", n2);
            this.oidTable.getHash(oID).put("Coords for Slot", new Vector(n));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(567, 41));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(25, 25));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(185, 25));
            this.oidTable.getHash(oID).put("Number of extra stuff in front", new Integer(3));
            this.oidTable.getHash(oID).put("Number of extra stuff in back", new Integer(0));
            this.oidTable.getHash(oID).put("Extras", new Vector());
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("RS232");
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("Power");
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("MDIPort1");
        }

        public String getModel(OID oID) {
            return (String)this.oidTable.getHash(oID).get("Model");
        }

        public String getFrontImage(OID oID) {
            return (String)this.oidTable.getHash(oID).get("Front Image");
        }

        public String getBackImage(OID oID) {
            return (String)this.oidTable.getHash(oID).get("Back Image");
        }

        public Point getFrontPosition(OID oID) {
            return (Point)this.oidTable.getHash(oID).get("Front Position");
        }

        public Point getBackPosition(OID oID) {
            return (Point)this.oidTable.getHash(oID).get("Back Position");
        }

        public int getNumSlots(OID oID) {
            return (Integer)this.oidTable.getHash(oID).get("Number of Slots");
        }

        public int getNumPorts(OID oID) {
            return (Integer)this.oidTable.getHash(oID).get("Number of ports");
        }

        public Point getSlotCoords(OID oID, int n) {
            if (n - 1 >= ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).size()) {
                return new Point(-1, -1);
            }
            return (Point)((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).elementAt(n - 1);
        }

        public int getNumOfExtrasFront(OID oID) {
            return (Integer)this.oidTable.getHash(oID).get("Number of extra stuff in front");
        }

        public int getNumOfExtrasBack(OID oID) {
            return (Integer)this.oidTable.getHash(oID).get("Number of extra stuff in back");
        }

        public String getExtras(OID oID, int n) {
            if (n >= ((Vector)this.oidTable.getHash(oID).get("Extras")).size()) {
                return new String();
            }
            return (String)((Vector)this.oidTable.getHash(oID).get("Extras")).elementAt(n);
        }

        public boolean containsKey(OID oID) {
            return this.oidTable.containsKey(oID);
        }

        public void dispose() {
            this.oidTable.clear();
        }
    }

    private class UFCTable
    extends Hashtable {
        public void create(Integer n) {
            try {
                this.put(n, new Hashtable());
                return;
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
        }

        public Hashtable getProp(Integer n) {
            if (this.containsKey(n)) {
                return (Hashtable)this.get(n);
            }
            return (Hashtable)this.get(new Integer(999));
        }

        UFCTable() {
            BoxInfo.this = BoxInfo.this;
        }
    }

    private class UFCInfo {
        UFCTable ufcTypes;

        public UFCInfo() {
            BoxInfo.this = BoxInfo.this;
            this.ufcTypes = new UFCTable();
            Integer n = new Integer(30);
            this.ufcTypes.create(n);
            this.ufcTypes.getProp(n).put("Name", "1PortTX");
            this.ufcTypes.getProp(n).put("Image", "1Port100BaseTX.gif");
            this.ufcTypes.getProp(n).put("Number of Ports", new Integer(1));
            n = new Integer(300);
            this.ufcTypes.create(n);
            this.ufcTypes.getProp(n).put("Name", "2PortTX_v2");
            this.ufcTypes.getProp(n).put("Image", "2Port100BaseTX_v2.gif");
            this.ufcTypes.getProp(n).put("Number of Ports", new Integer(1));
            n = new Integer(3);
            this.ufcTypes.create(n);
            this.ufcTypes.getProp(n).put("Name", "2PortTX");
            this.ufcTypes.getProp(n).put("Image", "2Port100BaseTX.gif");
            this.ufcTypes.getProp(n).put("Number of Ports", new Integer(1));
            n = new Integer(50);
            this.ufcTypes.create(n);
            this.ufcTypes.getProp(n).put("Name", "1PortFX");
            this.ufcTypes.getProp(n).put("Image", "1Port100BaseFX.gif");
            this.ufcTypes.getProp(n).put("Number of Ports", new Integer(1));
            n = new Integer(500);
            this.ufcTypes.create(n);
            this.ufcTypes.getProp(n).put("Name", "2PortFX_v2");
            this.ufcTypes.getProp(n).put("Image", "2Port100BaseFX_v2.gif");
            this.ufcTypes.getProp(n).put("Number of Ports", new Integer(1));
            n = new Integer(5);
            this.ufcTypes.create(n);
            this.ufcTypes.getProp(n).put("Name", "2PortFX");
            this.ufcTypes.getProp(n).put("Image", "2Port100BaseFX.gif");
            this.ufcTypes.getProp(n).put("Number of Ports", new Integer(1));
            n = new Integer(999);
            this.ufcTypes.create(n);
            this.ufcTypes.getProp(n).put("Name", "BAD");
            this.ufcTypes.getProp(n).put("Image", "none");
            this.ufcTypes.getProp(n).put("Number of Ports", new Integer(0));
        }

        public String getName(Integer n) {
            return (String)this.ufcTypes.getProp(n).get("Name");
        }

        public String getImage(Integer n) {
            return (String)this.ufcTypes.getProp(n).get("Image");
        }

        public int getNumPorts(Integer n) {
            return (Integer)this.ufcTypes.getProp(n).get("Number of ports");
        }

        public void dispose() {
            this.ufcTypes.clear();
        }
    }
}

